function prodMat = times(a,b)
%TIMES overload times operator to provide scalar multiplication for
%AdjacencyMatrix objects.  This function will be called in case the user
%enters a command of the form '2 .* adjMat'

if ~isnumeric(a) || numel(a)>1
    error('AdjacencyMatrix:times','AdjacencyMatrix objects can only be multiplied by scalar values')
end

prodMat = AdjacencyMatrix(a.*b.A,b.rowLabels,b.columnLabels);

end

